<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require 'db.php';

// Jika sudah login, langsung ke home
if (isset($_SESSION['user_id'])) {
    header("Location: home.php");
    exit;
}

if (isset($_POST['login'])) {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $query = mysqli_query($conn, "SELECT * FROM users WHERE email = '$email'");
    $user = mysqli_fetch_assoc($query);

    // Verifikasi password (admin / 123 sudah diatur sebelumnya)
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['name'] = $user['name'];
        header("Location: home.php");
        exit;
    } else {
        $error = "Email atau password salah!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Titik Kumpul</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="mobile-container">
        <div class="login-header">
            <div class="logo-icon">📍</div>
            <h2 style="font-weight: 600;">Titik Kumpul</h2>
            <p style="font-size: 12px; opacity: 0.9;">Internal Event Ticketing</p>
        </div>

        <div class="p-20">
            <h2 style="color: #333; margin-bottom: 5px;">Welcome!</h2>
            <p style="color: #888; font-size: 13px; margin-bottom: 20px;">Silakan login untuk melanjutkan.</p>

            <?php if(isset($error)): ?>
                <div class="error-msg">
                    <i class="fa-solid fa-circle-exclamation"></i> <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="input-group">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" value="admin@titik.kumpul" required>
                </div>
                <div class="input-group">
                    <label>Password</label>
                    <input type="password" name="password" class="form-control" placeholder="•••••••" required>
                </div>

                <div style="text-align: right; font-size: 12px; margin-bottom: 20px;">
                    <a href="#" style="color: #20B2AA;">Lupa Password?</a>
                </div>

                <button type="submit" name="login" class="btn-primary">Sign In</button>
            </form>

            <div class="text-center" style="margin-top: 30px; font-size: 12px; color: #aaa;">
                or continue with
            </div>

            <div class="social-login">
                <div class="social-btn" style="color:#DB4437;"><i class="fab fa-google"></i></div>
                <div class="social-btn" style="color:#333;"><i class="fab fa-github"></i></div>
                <div class="social-btn" style="color:#4267B2;"><i class="fab fa-facebook-f"></i></div>
            </div>
        </div>
    </div>
</body>
</html>